import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay_agent/core/helper/date_converter.dart';
import 'package:viserpay_agent/core/helper/string_format_helper.dart';
import 'package:viserpay_agent/core/utils/dimensions.dart';
import 'package:viserpay_agent/core/utils/my_strings.dart';
import 'package:viserpay_agent/data/controller/home/home_controller.dart';
import 'package:viserpay_agent/view/components/bottom-sheet/bottom_sheet_header_row.dart';
import 'package:viserpay_agent/view/components/column_widget/card_column.dart';

class LatestTransactionBottomSheet extends StatelessWidget {
  final int index;
  const LatestTransactionBottomSheet({super.key, required this.index});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<HomeController>(
      builder: (controller) => Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          const BottomSheetHeaderRow(header: MyStrings.details),
          const SizedBox(height: Dimensions.space15),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Expanded(
                  child: CardColumn(
                header: MyStrings.transactionId.tr,
                body: controller.trxList[index].trx ?? "",
              )),
              Expanded(
                child: CardColumn(
                  alignmentEnd: true,
                  header: MyStrings.date.tr,
                  body: DateConverter.convertIsoToString(
                    controller.trxList[index].createdAt ?? "",
                  ),
                ),
              ),
            ],
          ),
          const SizedBox(height: Dimensions.space15),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Expanded(
                child: CardColumn(
                    header: MyStrings.amount.tr,
                    body: "${controller.defaultCurrencySymbol}${Converter.formatNumber(
                      controller.trxList[index].beforeCharge ?? "",
                    )}"),
              ),
              Expanded(
                child: CardColumn(
                    alignmentEnd: true,
                    header: MyStrings.charge.tr,
                    body: "${controller.defaultCurrencySymbol}${Converter.formatNumber(
                      controller.trxList[index].charge ?? "",
                    )}"),
              ),
            ],
          ),
          const SizedBox(height: Dimensions.space15),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Expanded(
                child: CardColumn(
                  alignmentEnd: false,
                  header: MyStrings.finalAmount.tr,
                  body: "${controller.defaultCurrencySymbol}${Converter.formatNumber(
                    controller.trxList[index].amount ?? "",
                  )}",
                  // bodyTextDecoration: regularSmall.copyWith(color: MyColor.colorRed),
                ),
              ),
              Expanded(
                child: CardColumn(
                  alignmentEnd: true,
                  header: MyStrings.remainingBalance.tr,
                  body: "${Converter.formatNumber(controller.trxList[index].postBalance ?? "")} ${controller.defaultCurrency}",
                ),
              ),
            ],
          ),
          const SizedBox(height: Dimensions.space15),
          CardColumn(
            alignmentEnd: false,
            header: MyStrings.details.tr,
            body: "${controller.trxList[index].details}",
            bodyMaxLine: 8,
          )
        ],
      ),
    );
  }
}
